#ifndef INTEGRATION_KERNEL_H
#define INTEGRATION_KERNEL_H

#include <stdio.h>
#include "functions.h"

/**
 * Kernel for 2D function integration
 */
template <typename T, typename F>
__global__ void integrate2d_kernel(T start, T delta,
														unsigned int iterations, T * result)
{
    unsigned int tid = threadIdx.x;
    unsigned int bid = blockIdx.x;
		unsigned int bsize = blockDim.x;
		T thread_result = 0.0;

		/**
		 * Complete this kernel to calculate the correct part of the integral
		 * Then put the calculated value into the result array
		 */
}

/**
 * Wrapper function for launching 2D function integration kernel
 */
template <typename T, typename F>
void integrate2d(unsigned int blocks, unsigned int threads,
								 T start, T delta, unsigned int iterations, T * result)
{
  dim3 dimBlock(threads, 1, 1);
  dim3 dimGrid(blocks, 1, 1);
	integrate2d_kernel<T, F><<< dimGrid, dimBlock >>>
		(start, delta, iterations, result);
}

/**
 * Declare function prototype to force compiler to generate it
 */
template
void integrate2d<float, x_squared_functor<float> >(
	unsigned int blocks, unsigned int threads,
	float start, float delta, unsigned int iterations, float * result);

#endif // #ifndef INTEGRATION_KERNEL_H
