#ifndef FUNCTIONS_H
#define FUNCTIONS_H


template <typename T>
struct x_squared_functor {
  inline __host__ __device__ T operator()(T x) 
	{
    return x*x;
  }
};

template <typename T>
struct x_sqrtf_functor {
  inline __host__ __device__ T operator()(T x) 
	{
    return sqrtf(x);
  }
};


template <typename T>
struct x_complex_functor {
  inline __host__ __device__ T operator()(T x) 
	{
    return x * sin(x);
  }
};





#endif